#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmBloodUnitMaintain;


#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
    [TestFixture]
    public class BOL_ABORh : BaseTest 
    {
		private BOL.AboRh _aboRh;

		[SetUp]
		protected void SetUp() 
		{	
			base.BaseSetUp();

			if (this.RefreshData)
			{
				this._aboRh = new BOL.AboRh();
				this._aboRh.SetInitialBrokenRules(BROKEN.FormClassName);

				this.RefreshData = false;
			}
		}

        [Test]
		public void Ctor_Blank_Pass()
		{
			BOL.AboRh objTest = new BOL.AboRh();

			Assert.AreEqual(Common.ABO.NA, objTest.Abo, "Abo ");
			Assert.AreEqual(Common.RH.NotProvided, objTest.RH, "Rh");
		}

        [Test]
		[Ignore]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_Abo_Rh_Pass()
		{
			BOL.AboRh objTest = new BOL.AboRh(Common.ABO.Mx, Common.RH.PooledRH);

			Assert.AreEqual(Common.ABO.Mx, objTest.Abo, "Abo");
			Assert.AreEqual(Common.RH.PooledRH, objTest.RH, "Rh");
		}

		[Test]
		[Ignore]
		public void Ctor_Abo_Rh_Fail()
		{
		}

		[Test]
		public void ABO_Pass()
		{
			this._aboRh.Abo = Common.ABO.AB;
			
			Assert.AreEqual(Common.ABO.AB, this._aboRh.Abo);
		}

		[Test]
		public void ABO_Fail()
		{
			this.RefreshData = true;

			this._aboRh.Abo = Common.ABO.NA;
			
			Assert.AreEqual(true, this._aboRh.IsRuleBroken(BROKEN.Abo), "BrokenRule");
		}

		[Test]
		public void ABORhText_Pass()
		{
			this._aboRh.Abo = Common.ABO.A;
			this._aboRh.RH = Common.RH.Negative;
			Assert.AreEqual("A Neg", this._aboRh.AboRHText.Trim(),"A Neg");

			this._aboRh.Abo = Common.ABO.Mx;
			Assert.AreEqual("Pooled Neg", this._aboRh.AboRHText.Trim(),"Pooled Neg");

			this._aboRh.Abo = Common.ABO.NA;
			Assert.AreEqual("NR", this._aboRh.AboRHText, "NR");

			this._aboRh.Abo = Common.ABO.AB;
			this._aboRh.RH = Common.RH.NotProvided;
			Assert.AreEqual("AB", this._aboRh.AboRHText.Trim(), "AB");

			this._aboRh.Abo = Common.ABO.Mx;
			Assert.AreEqual("Pooled", this._aboRh.AboRHText.Trim(), "Pooled");
		}

		[Test]
		[Ignore]
		public void ABORhText_Fail()
		{
		}

		[Test]
		public void AboRHTextExpanded_Pass()
		{
			this._aboRh.Abo = Common.ABO.A;
			this._aboRh.RH = Common.RH.Negative;
			Assert.AreEqual("A Neg", this._aboRh.AboRHTextExpanded, "A Neg");

			this._aboRh.Abo = Common.ABO.NA;
			Assert.AreEqual("NR", this._aboRh.AboRHTextExpanded, "NR");

			this._aboRh.Abo = Common.ABO.AB;
			this._aboRh.RH = Common.RH.NotProvided;
			Assert.AreEqual("AB", this._aboRh.AboRHTextExpanded, "AB");

			this._aboRh.Abo = Common.ABO.Mx;
			this._aboRh.RH = Common.RH.NotProvided;
			Assert.AreEqual("Pooled ABO", this._aboRh.AboRHTextExpanded, "Pooled ABO");

			this._aboRh.Abo = Common.ABO.Mx;
			this._aboRh.RH = Common.RH.Negative;
			Assert.AreEqual("Pooled ABO Neg", this._aboRh.AboRHTextExpanded, "Pooled ABO Neg");

			this._aboRh.Abo = Common.ABO.Mx;
			this._aboRh.RH = Common.RH.PooledRH;
			Assert.AreEqual("Pooled ABO Pooled", this._aboRh.AboRHTextExpanded, "Pooled ABO Pooled");

			this._aboRh.Abo = Common.ABO.I;
			this._aboRh.RH = Common.RH.Inconclusive;
			Assert.AreEqual("I Inc", this._aboRh.AboRHTextExpanded, "I Inc");


		}

		[Test]
		[Ignore]
		public void AboRHTextExpanded_Fail()
		{
		}

		[Test]
		public void RH_Pass()
		{
			this._aboRh.RH = Common.RH.Blank;
			Assert.AreEqual(Common.RH.Blank, this._aboRh.RH);
		}

		[Test]
		[Ignore]
		public void RH_Fail()
		{
		}

		[Test]
		public void RHFactorCode_Pass()
		{
			this._aboRh.RH = Common.RH.Blank;
			Assert.AreEqual("Z", this._aboRh.RHFactorCode, "Blank");

			this._aboRh.RH = Common.RH.Inconclusive;
			Assert.AreEqual("I", this._aboRh.RHFactorCode, "Inconclusive");

			this._aboRh.RH = Common.RH.Negative;
			Assert.AreEqual("N", this._aboRh.RHFactorCode, "Negative");

			this._aboRh.RH = Common.RH.NotProvided;
			Assert.AreEqual("U", this._aboRh.RHFactorCode, "NotProvided");

			this._aboRh.RH = Common.RH.PooledRH;
			Assert.AreEqual("Y", this._aboRh.RHFactorCode, "PooledRH");

			this._aboRh.RH = Common.RH.Positive;
			Assert.AreEqual("P", this._aboRh.RHFactorCode, "Positive");
		}

		[Test]
		[Ignore]
		public void RHFactorCode_Fail()
		{
		}

		[Test]
		public void RhFactorText_Pass()
		{
			this._aboRh.RH = Common.RH.Blank;
			Assert.AreEqual("", this._aboRh.RHFactorText, "Blank");

			this._aboRh.RH = Common.RH.Inconclusive;
			Assert.AreEqual("Inc", this._aboRh.RHFactorText, "Inconclusive");

			this._aboRh.RH = Common.RH.Negative;
			Assert.AreEqual("Neg", this._aboRh.RHFactorText, "Negative");

			this._aboRh.RH = Common.RH.NotProvided;
			Assert.AreEqual("Unk", this._aboRh.RHFactorText, "NotProvided");

			this._aboRh.RH = Common.RH.PooledRH;
			Assert.AreEqual("Pooled", this._aboRh.RHFactorText, "PooledRH");

			this._aboRh.RH = Common.RH.Positive;
			Assert.AreEqual("Pos", this._aboRh.RHFactorText, "Positive");
		}

		[Test]
		[Ignore]
		public void RhFactorText_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			BOL.AboRh objTest = new BOL.AboRh(Common.ABO.AB, Common.RH.Negative);
			DataTable dt = new DataTable();
		
			dt.Columns.Add(TABLES.RhFactor.RhFactorCode, typeof(string));
			dt.Columns.Add(TABLES.RhFactor.RhFactorText, typeof(string));
			dt.Columns.Add(TABLES.BloodType.BloodTypeCode, typeof(string));
			DataRow dtRow = dt.NewRow();
			
			dtRow = objTest.LoadDataRowFromThis(dtRow);

			Assert.AreEqual(objTest.RHFactorCode, dtRow[TABLES.RhFactor.RhFactorCode].ToString(), "RhFactorCode");
			Assert.AreEqual(objTest.RHFactorText, dtRow[TABLES.RhFactor.RhFactorText].ToString(), "RhFactorText");
			Assert.AreEqual(objTest.Abo.ToString(), dtRow[TABLES.BloodType.BloodTypeCode].ToString(), "BloodTypeCode");
		}

		[Test]
		[Ignore]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void GetRHFromCode_Pass()
		{
			Common.RH testValue;

			testValue = BOL.AboRh.GetRHFromCode("P");
			Assert.AreEqual(Common.RH.Positive, testValue, "Positive");

			testValue = BOL.AboRh.GetRHFromCode("N");
			Assert.AreEqual(Common.RH.Negative, testValue, "Negative");

			testValue = BOL.AboRh.GetRHFromCode("I");
			Assert.AreEqual(Common.RH.Inconclusive, testValue, "Inconclusive");

			testValue = BOL.AboRh.GetRHFromCode("U");
			Assert.AreEqual(Common.RH.NotProvided, testValue, "NotProvided");

			testValue = BOL.AboRh.GetRHFromCode("Y");
			Assert.AreEqual(Common.RH.PooledRH, testValue, "Pooled");

			testValue = BOL.AboRh.GetRHFromCode("Z");
			Assert.AreEqual(Common.RH.Blank, testValue, "Blank");

			testValue = BOL.AboRh.GetRHFromCode("");
			Assert.AreEqual(Common.RH.NotProvided, testValue, "NotProvided");
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void GetRHFromCode_Fail()
		{
			BOL.AboRh.GetRHFromCode("@");
		}

		[Test]
		public void GetAllABORh_Pass()
		{
			DataTable dtTest = BOL.AboRh.GetAllAboRH();
			Assert.IsTrue(dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		[Ignore]
		public void GetAllABORh_Fail()
		{
		}

		[Test]
		public void GetABOFromString_Pass()
		{
			Common.ABO testValue;

			testValue = BOL.AboRh.GetAboFromString("A");
			Assert.AreEqual(Common.ABO.A, testValue, "A");

			testValue = BOL.AboRh.GetAboFromString("B");
			Assert.AreEqual(Common.ABO.B, testValue, "B");

			testValue = BOL.AboRh.GetAboFromString("AB");
			Assert.AreEqual(Common.ABO.AB, testValue, "AB");

			testValue = BOL.AboRh.GetAboFromString("O");
			Assert.AreEqual(Common.ABO.O, testValue, "O");

			testValue = BOL.AboRh.GetAboFromString("POOLED");
			Assert.AreEqual(Common.ABO.Mx, testValue, "Pooled");

			testValue = BOL.AboRh.GetAboFromString("MX");
			Assert.AreEqual(Common.ABO.Mx, testValue, "Mixed");
			
			testValue = BOL.AboRh.GetAboFromString("I");
			Assert.AreEqual(Common.ABO.I, testValue, "Inconclusive");
		}

		[Test]
		[Ignore]
		public void GetABOFromString_Fail()
		{
		}

    }
}
#endif
